package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;

import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityHelpBinding;
import app.firezone.synk.network.model.AppModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class HelpActivity extends AppCompatActivity {

    ActivityHelpBinding binding;

    String whatsapp, instagram, facebook, telegram, youtube, discord, email;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityHelpBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        // Disable email/help button until data is fetched
        binding.facebook.setEnabled(false);
        binding.facebook.setAlpha(0.5f); // make it look disabled

        loadData();

        // Social buttons
        binding.discord.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW);
            browserIntent.setData(Uri.parse("https://wa.me/91" + whatsapp));
            startActivity(browserIntent);
        });

        binding.cardView37.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW);
            browserIntent.setData(Uri.parse(instagram));
            startActivity(browserIntent);
        });

        binding.cardView36.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW);
            browserIntent.setData(Uri.parse("https://wa.me/91" + whatsapp));
            startActivity(browserIntent);
        });

        binding.cardView38.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW);
            browserIntent.setData(Uri.parse(youtube));
            startActivity(browserIntent);
        });

        binding.telegram.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW);
            browserIntent.setData(Uri.parse(telegram));
            startActivity(browserIntent);
        });
    }

    private void loadData() {
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();

        call.enqueue(new Callback<ArrayList<AppModel>>() {
            @Override
            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    AppModel model = response.body().get(0);

                    whatsapp = model.getWhatsapp();
                    facebook = model.getFacebook();
                    telegram = model.getTelegram();
                    youtube = model.getYoutube();
                    instagram = model.getInstagram();
                    email = model.getEmail();
                    discord = model.getDiscord();

                    // Enable email button now that email is available
                    binding.facebook.setEnabled(true);
                    binding.facebook.setAlpha(1f); // reset visual appearance

                    binding.facebook.setOnClickListener(view -> {
                        Intent intent = new Intent(Intent.ACTION_SENDTO);
                        intent.setData(Uri.parse("mailto:"));
                        intent.putExtra(Intent.EXTRA_EMAIL, new String[]{email});
                        intent.putExtra(Intent.EXTRA_SUBJECT, getString(R.string.help_to_improve_us_email_subject));
                        intent.putExtra(Intent.EXTRA_TEXT, getString(R.string.help_to_improve_us_body));

                        try {
                            startActivity(Intent.createChooser(intent, "Send mail"));
                        } catch (ActivityNotFoundException ex) {
                            Toast.makeText(HelpActivity.this, "No Mail App found", Toast.LENGTH_SHORT).show();
                        } catch (Exception ex) {
                            Toast.makeText(HelpActivity.this, "Unexpected Error", Toast.LENGTH_SHORT).show();
                        }
                    });

                } else {
                    Toast.makeText(HelpActivity.this, "No data found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                Toast.makeText(HelpActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
}
